//=============================================================================
// ut_ShieldBelt.
//=============================================================================
class XmasShieldBelt extends UT_ShieldBelt;


//#exec TEXTURE IMPORT NAME=xmasbelt FILE=Textures\xmasAbelt1.bmp

#exec mesh import mesh=SantasBelt anivfile=Models\SantasBelt_a.3d datafile=Models\SantasBelt_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=SantasBelt x=0 y=0 z=0
#exec mesh sequence mesh=SantasBelt seq=All startframe=0 numframes=1

#exec meshmap new meshmap=SantasBelt mesh=SantasBelt
#exec meshmap scale meshmap=SantasBelt x=0.04688 y=0.04688 z=0.09375

#exec AUDIO IMPORT FILE="Sounds\xmasBelt.WAV" NAME="xmasBelt"

var UT_ShieldBeltEffect MyEffect;
var() string TeamFireTextureStrings[4];
var() string TeamTextureStrings[4];
var firetexture TeamFireTextures[4];
var texture TeamTextures[4];
var int TeamNum;

event float BotDesireability( pawn Bot )
{
	local inventory Inv;

	for ( Inv=Bot.inventory; Inv!=None; Inv=Inv.inventory )
		if ( Inv.IsA('RelicDefenseInventory') )
			return -1; //can't pickup up shieldbelt if have defense relic

	return Super.BotDesireability(Bot);
}

function bool HandlePickupQuery( inventory Item )
{
	local Inventory I;

	if (item.class == class) 
	{
		// remove other armors
		for ( I=Owner.Inventory; I!=None; I=I.Inventory )
			if ( I.bIsAnArmor && (I != self) )
				I.Destroy();
	}

	return Super.HandlePickupQuery(Item);
}

function ArmorImpactEffect(vector HitLocation)
{ 
	if ( Owner.IsA('PlayerPawn') )
	{
		PlayerPawn(Owner).ClientFlash(-0.05,vect(400,400,400));
		PlayerPawn(Owner).PlaySound(DeActivateSound, SLOT_None, 2.7*PlayerPawn(Owner).SoundDampening);
	}
	if ( MyEffect != None )
	{
		//MyEffect.Texture = MyEffect.LowDetailTexture;
		MyEffect.ScaleGlow = 4.0;
		MyEffect.Fatness = 255;
		SetTimer(0.8, false);
	}
}

function Timer()
{
	if ( MyEffect != None )
	{
		MyEffect.Fatness = MyEffect.Default.Fatness;
		SetEffectTexture();
	}
}

function Destroyed()
{
	if ( Owner != None )
	{
		Owner.SetDefaultDisplayProperties();
		if( Owner.Inventory != None )
			Owner.Inventory.SetOwnerDisplay();
	}
	if ( MyEffect != None )
		MyEffect.Destroy();
	Super.Destroyed();
}

function PickupFunction(Pawn Other)
{
	local Inventory I;

	MyEffect = Spawn(class'UT_ShieldBeltEffect', Other,,Other.Location, Other.Rotation); 
	MyEffect.Mesh = Owner.Mesh;
	MyEffect.DrawScale = Owner.Drawscale;

	if ( Level.Game.bTeamGame && (Other.PlayerReplicationInfo != None) )
		TeamNum = Other.PlayerReplicationInfo.Team;
	else
		TeamNum = 3;
	SetEffectTexture();

	I = Pawn(Owner).FindInventoryType(class'UT_Invisibility');
	if ( I != None )
		MyEffect.bHidden = true;
	
	// remove other armors
	for ( I=Owner.Inventory; I!=None; I=I.Inventory )
		if ( I.bIsAnArmor && (I != self) )
			I.Destroy();
}

function SetEffectTexture()
{
	if ( TeamNum != 3 )
		MyEffect.ScaleGlow = 0.5;
	else
		MyEffect.ScaleGlow = 1.0;
	MyEffect.ScaleGlow *= (0.25 + 0.75 * Charge/Default.Charge);
	if ( TeamFireTextures[TeamNum] == None )
		TeamFireTextures[TeamNum] =FireTexture(DynamicLoadObject(TeamFireTextureStrings[TeamNum], class'Texture'));
	MyEffect.Texture = TeamFireTextures[TeamNum];
	if ( TeamTextures[TeamNum] == None )
		TeamTextures[TeamNum] = Texture(DynamicLoadObject(TeamTextureStrings[TeamNum], class'Texture'));
	MyEffect.LowDetailTexture = TeamTextures[TeamNum];
}

defaultproperties
{
     TeamFireTextureStrings(0)="UnrealShare.Belt_fx.ShieldBelt.RedShield"
     TeamFireTextureStrings(1)="UnrealShare.Belt_fx.ShieldBelt.BlueShield"
     TeamFireTextureStrings(2)="UnrealShare.Belt_fx.ShieldBelt.Greenshield"
     TeamFireTextureStrings(3)="UnrealShare.Belt_fx.ShieldBelt.N_Shield"
     TeamTextureStrings(0)="UnrealShare.Belt_fx.ShieldBelt.newred"
     TeamTextureStrings(1)="UnrealShare.Belt_fx.ShieldBelt.newblue"
     TeamTextureStrings(2)="UnrealShare.Belt_fx.ShieldBelt.newgreen"
     TeamTextureStrings(3)="UnrealShare.Belt_fx.ShieldBelt.newgold"
     TeamFireTextures(0)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
     TeamFireTextures(1)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
     TeamFireTextures(2)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.Greenshield'
     TeamFireTextures(3)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.N_Shield'
     TeamTextures(0)=Texture'UnrealShare.Belt_fx.ShieldBelt.newred'
     TeamTextures(1)=Texture'UnrealShare.Belt_fx.ShieldBelt.newblue'
     TeamTextures(2)=Texture'UnrealShare.Belt_fx.ShieldBelt.newgreen'
     TeamTextures(3)=Texture'UnrealShare.Belt_fx.ShieldBelt.newgold'
     PickupMessage="You got Santas shieldbelt."
     ItemName="Xmas ShieldBelt"
     PickupViewMesh=Mesh'DanesXmas_v2009.SantasBelt'
     PickupSound=Sound'DanesXmas_v2009.xmasBelt'
     Mesh=Mesh'DanesXmas_v2009.SantasBelt'
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'DanesXmas_v2009.Gold'
     MultiSkins(1)=Texture'DanesXmas_v2009.Black'
}
